#ifndef SIMPLESERIAL_ANALYZER_RESULTS
#define SIMPLESERIAL_ANALYZER_RESULTS

#include <AnalyzerResults.h>

class SimpleSerialAnalyzer;
class SimpleSerialAnalyzerSettings;

#define FRAME_TYPE_RAW_BIT		0	//data1 is val, data2 is phase, data2 == 0 means both fell at once
#define FRAME_TYPE_START		1
#define FRAME_TYPE_STOP			2
#define FRAME_TYPE_BYTE			3
#define FRAME_TYPE_WORD			4
#define FRAME_TYPE_INCOMPL_WORD	5	//trans & word view (data2 is num bytes we have)
#define FRAME_TYPE_HEADER		6	//trans view
#define FRAME_TYPE_FUNC			7	//trans view
#define FRAME_TYPE_FUNCS_ORRED	8	//trans view
#define FRAME_TYPE_2b_AND_2c	9	//trans: 2 bytes and 2 chars
#define FRAME_TYPE_4c			10	//trans: 4 chars
#define FRAME_TYPE_2_LE_s		11	//trans: 2 little-ending shorts
#define FRAME_TYPE_PT_PH_BLK	12	//trans: partition, phase, block
#define FRAME_TYPE_CRC			13	//trans & word view (data2 is expected val)

#define CMD_REQ_DEV_NFO				0x01
#define CMD_REX_ETD_NFO				0x02
#define CMD_RST_DEV					0x03
#define CMD_SHTDWN_DEV				0x04
#define RSP_DEV_NFO					0x05
#define RSP_EXTD_NFO				0x06
#define RSP_CMD_ACK					0x07
#define RSP_DATA_XFER				0x08
#define CMD_GET_COND				0x09
#define CMD_GET_MEM_NFO				0x0A
#define CMD_BLK_RD					0x0B
#define CMD_BLK_WR					0x0C
#define CMD_FLSH_ICON_OFF			0x0D
#define CMD_SET_COND				0x0E
#define CMD_ERROR_CODE				0xFA	//includes word of error
#define CMD_ERROR_PLZ_RESEND_PACKET	0xFC	//no data
#define CMD_ERROR_CMD_UNKNOWN		0xFD	//no data
#define CMD_ERROR_FUNC_UNKNOWN		0xFE	//no data


#define FUNC_CONTROLLER			0x0001
#define FUNC_MEMORY				0x0002
#define FUNC_LCD				0x0004
#define FUNC_CLOCK				0x0008
#define FUNC_MICROPHONE			0x0010
#define FUNC_AR_GUN				0x0020
#define FUNC_KEYBOARD			0x0040
#define FUNC_LIGHT_GUN			0x0080
#define FUNC_VIBRATION_PACK		0x0100
#define FUNC_MOUSE				0x0200


class SimpleSerialAnalyzerResults : public AnalyzerResults
{
public:
	SimpleSerialAnalyzerResults( SimpleSerialAnalyzer* analyzer, SimpleSerialAnalyzerSettings* settings );
	virtual ~SimpleSerialAnalyzerResults();

	virtual void GenerateBubbleText( U64 frame_index, Channel& channel, DisplayBase display_base );
	virtual void GenerateExportFile( const char* file, DisplayBase display_base, U32 export_type_user_id );

	virtual void GenerateFrameTabularText(U64 frame_index, DisplayBase display_base );
	virtual void GeneratePacketTabularText( U64 packet_id, DisplayBase display_base );
	virtual void GenerateTransactionTabularText( U64 transaction_id, DisplayBase display_base );

protected: //functions

protected:  //vars
	SimpleSerialAnalyzerSettings* mSettings;
	SimpleSerialAnalyzer* mAnalyzer;

private:
	void GenerateText( U64 frame_index, Channel* channel /* can be NULL */, DisplayBase display_base, bool onlyOne);
};

#endif //SIMPLESERIAL_ANALYZER_RESULTS
